﻿using VeteransAffairs.Registries.BusinessManager;

public class ImagingBasePage : BasePage
{
    protected const string DateFormat = "M/d/yyyy";
    protected const string OriginallyNavigatedFrom = "OriginallyNavigatedFrom";

    private EFRPatientManager _patientManager;
    protected EFRPatientManager GetPatientManager()
    {
        if (_patientManager == null)
            _patientManager = new EFRPatientManager();

        return _patientManager;
    }

    protected PatientSummary GetOrStorePatientSummary()
    {
        int patientId = 0;
        int.TryParse(Request.QueryString["patientId"], out patientId);

        return patientId > 0 ?
            GetOrStore("PatientSummary",
                (existing) =>
                {
                    return existing.Id != patientId;
                },
                () =>
                {
                    var patient = GetPatientManager().SelectByID(patientId);
                    return new PatientSummary(patient);
                })
            : null;
    }

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string AppObjectCode()
    {
        return "EFR_PATIENTS";
    }

    public override string MenuItemName()
    {
        return "EFR_PATIENTS";
    }
}